class Team
{
	array<Peer@> members;
	string shapeName;
	string teamName;
	
	// This rounds
	uint8 deaths;
	uint8 escaped;
	uint8 points;
	uint8 frags;
	uint8 living;	// Total player count
	
	uint8 totalEscaped;
	uint8 totalDeaths;
	uint8 totalPoints;
	uint8 totalFrags;
	
	bool nomore;
	
	Team()
	{
	// To be set every new round actually
		deaths = 0;
		escaped = 0;
		living = 0;
		points = 0;
		frags = 0;
		
		totalEscaped = 0;
		totalDeaths = 0;
		totalPoints = 0;
		totalFrags = 0;
	}
	void OnRoundBegin()
	{
		// Play a song maybe?
	}
	void EndRoundCalculation()
	{	
		deaths = 0;
		escaped = 0;
		living = 0;
		points = 0;
		frags = 0;
		
		for (uint8 it = 0; it < members.length(); it++)
		{
			if (members[it].player is null)
				continue;
			@members[it].player.myPeer = null;
			@members[it].player.asset = null;
			@members[it].player = null;
		}
	}
	
	void TeamLogic()
	{
		// This code counts the living players + sends condolences to the other players.
	}
}
enum HideAndSeek_State
{
	ROUND_IN_PROGRESS = 1,
	ROUND_COUNTDOWN
}
class HideAndSeek
{
	array<Team@> teams;
	
	array<Peer@> connectedPeers;
	
	Peer@ myPeer;
	
	uint8 seekingTeam;
	
	uint8 state;
	
	Timer losTimer;
	
	// Timers
	Timer countdown;
	string timerStr;
	uint roundTime;
	uint waitTime;
	
	uint width;
	uint height;
	
	HideAndSeek()
	{
		seekingTeam = 0;
		state = 0;
		timerStr = "";
		TeamsInit();
		
		waitTime = 0;
		roundTime = 0;
		
		@myPeer = null;
		
		GetWindowDimensions(width,height);
	}
	
	void TeamsInit()
	{
		Team redTeam;
		redTeam.shapeName = "Circle 2";
		redTeam.teamName = "red";
		Team blueTeam;
		blueTeam.shapeName = "Circle 1";
		blueTeam.teamName = "blue";
		Team orangeTeam;
		orangeTeam.shapeName = "Circle 3";
		orangeTeam.teamName = "orange";	
		Team greenTeam;
		greenTeam.shapeName = "Circle 4";
		greenTeam.teamName = "green";	
		
		teams.insertLast(@redTeam);
		teams.insertLast(@blueTeam);
		teams.insertLast(@orangeTeam);
		teams.insertLast(@greenTeam);
	}
	
	void CountdownBeforeNewRound()
	{
		timerStr = "New round begins in: ";
		timerStr += (waitTime - countdown.GetElapsedTime()) / 1000;
		DrawGUIText( timerStr, vec2(width / 2 - 50, 0), 18);	
		/*if (countdown.GetElapsedTime() > waitTime)
		{
			countdown.Reset();
		}*/
	}
	
	void LOSCheck()
	{
		AssetQ query;
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].player is null)
				continue;
			query.RayCast(myPeer.player.asset.GetPosition(), connectedPeers[t].player.asset.GetPosition());
			query.SetClassFilter("Static");
			uint results = query.RunQuery();
			if (results > 0)
				connectedPeers[t].player.visible = false;
			else
			{
				vec2 distance = myPeer.player.asset.GetPosition() - connectedPeers[t].player.asset.GetPosition();
				if (distance.LengthSq() < 1.4f && connectedPeers[t].player.alpha < 200)
					connectedPeers[t].player.alpha = 200;
				connectedPeers[t].player.visible = true;
			}
		}
	}
	void RoundBegin()
	{
		for (uint8 it = 0; it < teams.length(); it++)
		{
			teams[it].OnRoundBegin();
		}
	}
	void RoundEnd()
	{
		for (uint8 it = 0; it < teams.length(); it++)
		{
			teams[it].EndRoundCalculation();
		}
		@myPeer.player.myPeer = null;
		@myPeer.player.asset = null;
		@myPeer.player = null;
	}
	
	void Logic()
	{
		if (state == ROUND_COUNTDOWN)
		{
			CountdownBeforeNewRound();
			game.CameraControls();
			// Display informative text here, you can select your team during this phase as well
					// Team selection - Client requests from server to join that team - DO SOMETHING ELSE
			if (myPeer !is null && !myPeer.setupRequested && input.IsMBDown(MouseButton::Left))
			{
				BitStream stream;
				stream.Write(uint8(NetworkMessages::ID_PLAYER_SETUP));
				stream.Write("red");
				stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
				myPeer.setupRequested = true;
			}
			if (myPeer !is null && !myPeer.setupRequested && input.IsMBDown(MouseButton::Right))
			{
				BitStream stream;
				stream.Write(uint8(NetworkMessages::ID_PLAYER_SETUP));
				stream.Write("blue");
				stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
				myPeer.setupRequested = true;
			}
			if (myPeer !is null && !myPeer.setupRequested && input.IsMBDown(MouseButton::Middle))
			{
				BitStream stream;
				stream.Write(uint8(NetworkMessages::ID_PLAYER_SETUP));
				stream.Write("orange");
				stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
				myPeer.setupRequested = true;
			}
		}
		else if(state == ROUND_IN_PROGRESS)
		{
			timerStr = "Round ends in: ";
			timerStr += (roundTime - countdown.GetElapsedTime()) / 1000;
			DrawGUIText( timerStr, vec2(width / 2 - 50, 0), 18);	
			if (myPeer !is null && myPeer.player !is null)
			{
				
				string healthText = "Health : " + myPeer.player.health;
				DrawGUIText(healthText, vec2(0, 75), 18);
				SetCameraTransform(myPeer.player.asset.GetPosition(), 0);
				
				if (losTimer.GetElapsedTime() > 250)
				{
					LOSCheck();
					losTimer.Reset();
				}
			}
			else
				game.CameraControls();
		}
	}	
}
class Game
{
//	array<Team@> teams;
	
	HideAndSeek mod;
	
	vec2 cameraMoveTo;
	Timer cameraDelta;
	float cameraSpeed;
	
	Game()
	{
		cameraSpeed = 10.0f;
	}
	
	void CameraControls()
	{
		cameraMoveTo = vec2(0,0);
		if (input.IsKeyDown(Code::W))
			cameraMoveTo.y = -1;
		else if(input.IsKeyDown(Code::S))
			cameraMoveTo.y = 1;
		if (input.IsKeyDown(Code::D))
			cameraMoveTo.x = 1;
		else if (input.IsKeyDown(Code::A))
			cameraMoveTo.x = -1;
		if (cameraMoveTo.LengthSq() > 0)
		{
		cameraMoveTo.Normalize();
		cameraMoveTo *= cameraSpeed * cameraDelta.GetElapsedTime() / 1000;
		cameraMoveTo += GetCameraPos();
		SetCameraTransformCentered( cameraMoveTo, 0);
		}
		
		cameraDelta.Reset();
	}
	void ShowPlayerInfo()
	{
		string infoText;
		infoText = "Players:\n";
		
		infoText += mod.myPeer.peerName + "\n";
		
		for (uint t = 0; t < mod.connectedPeers.length(); t++)
		{
			infoText += mod.connectedPeers[t].peerName + "\n";
		}
		DrawGUIText(infoText, vec2(0, 120), 18);
	}
	void OnLoop()
	{
		// The problem with the random exception was, that this method was being called continuously and 
		// myPeer will not be initialised until a response from server.
		if (input.IsKeyDown(Code::Tab))
			ShowPlayerInfo();
		mod.Logic();
		DrawGUIText("Hide and Seek v0.5", vec2(0, 50), 18);
	}
	
	void RemovePeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < mod.connectedPeers.length(); t++)
		{
			if (mod.connectedPeers[t].guid == guid)
			{
				@mod.connectedPeers[t].player.myPeer = null;
				@mod.connectedPeers[t] = null;
				mod.connectedPeers.removeAt(t);
				break;
			}
		}
	}
	
	Peer@ GetPeerByGUID( uint64 guid )
	{
		if ( guid == mod.myPeer.guid)
			return mod.myPeer;
		for (uint t = 0; t < mod.connectedPeers.length(); t++)
		{
			if (mod.connectedPeers[t].guid == guid)
				return mod.connectedPeers[t];
		}
		return null;
	}
	
	Team@ GetTeamByName(string name)
	{
		for (uint t = 0; t < mod.teams.length(); t++)
		{
			if (mod.teams[t].teamName == name)
				return mod.teams[t];
		}
		return null;	
	}
}